local player = ...
local pn = tonumber(player:sub(-1))

local GraphWidth = THEME:GetMetric("GraphDisplay", "BodyWidth")
local GraphHeight = THEME:GetMetric("GraphDisplay", "BodyHeight")

return Def.ActorFrame{
	InitCommand=function(self) self:y(_screen.cy + 124) end,

	-- Draw a Quad behind the GraphDisplay (lifebar graph) and Judgment ScatterPlot
	Def.Quad{
		InitCommand=function(self)
			self:zoomto(GraphWidth, GraphHeight):diffuse(color("#101519")):vertalign(top)
		end
	},

	-- density graph
	LoadActor("./DensityGraph.lua", {player=player, GraphWidth=GraphWidth, GraphHeight=GraphHeight} ),

	-- use custom life graphs; don't draw graphdisplay
	LoadActor("./LifeGraphs.lua", {player=player, GraphWidth=GraphWidth, GraphHeight=GraphHeight} )..{
		InitCommand = function(self)
			if FindInTable(WF.DefaultPane[pn], WF.ITGCentricPanes) then
				self:queuecommand("Hide")
			end
		end,
		EvalPaneChangedMessageCommand = function(self, args)
			if args.pn ~= pn then return end
			self:finishtweening()
			local pane = WF.EvalPanes[pn][args.activepane]
			if pane and (FindInTable(pane:GetName(),WF.ITGCentricPanes) or pane:GetName() == "Timing") then
				self:queuecommand("Hide")
			else 
				self:queuecommand("Show")
			end
		end,
		ShowCommand = function(self)
			self:visible(true)
		end,
		HideCommand = function(self)
			self:visible(false)
		end
	},

	-- itg life graph
	LoadActor("./ITGLifeGraph.lua", player)..{
		InitCommand = function(self)
			if not FindInTable(WF.DefaultPane[pn], WF.ITGCentricPanes) then
				self:queuecommand("Hide")
			end
		end,
		EvalPaneChangedMessageCommand = function(self, args)
			if args.pn ~= pn then return end
			self:finishtweening()
			local pane = WF.EvalPanes[pn][args.activepane]
			if pane and (not FindInTable(pane:GetName(),WF.ITGCentricPanes)) then
				self:queuecommand("Hide")
			else 
				self:queuecommand("Show")
			end
		end,
		ShowCommand = function(self)
			self:visible(true)
		end,
		HideCommand = function(self)
			self:visible(false)
		end
	}
}